<?php
/**
 * Created by PhpStorm.
 * User: info_000
 * Date: 2015-12-11
 * Time: 10:41
 */

final class requestType{

    /**
     * List of API request Action and related toString function
     */
    const DATE = 0;
    const CATEGORY = 1;
    const PRODUCT = 2;
    const IMAGE = 3;
    const INVENTORY = 4;
    const ATTRIBUTES = 5;
    const SLIDE = 6;
    const STORE =  7;
    const CONFIG = 8;
    const PROMO = 9;
    const TAX = 10;
    const ADDTRANSACTION = 11;
    const APPLICATIONZONE = 12;
    const APPLICATIONZONELIST = 13;
    const GLEXPORTDATA = 14;
    const SERVICES = 15;
    const SHIPPINGATTRIBUTES = 16;
    const UPCLIST = 17;
    const MULTIIMAGE = 18;
    const ENTITYLIST = 19;
    const PROMOENDED = 20;
    const GLSUMMARYDATA = 21;
    const GLSINGLEINVOICE = 22;
    const GLACCOUNTLIST = 23;

    /**
     * Array for the complete list of Action
     * @var array
     */
    public static $RequestArray = array(
        self::DATE => "DateRequest",
        self::CATEGORY => "ACategoryRequest",
        self::PRODUCT => "AProductRequest",
        self::IMAGE => "AImageRequest",
        self::INVENTORY => "AInventoryRequest",
        self::ATTRIBUTES => "AProductAttributesRequest",
        self::PROMO => "APromoRequest",
        self::TAX => "ATaxRequest",
        self::ADDTRANSACTION => "AAddTransactionRequest",
        self::APPLICATIONZONE => "AApplicationZoneRequest",
        self::APPLICATIONZONELIST => "AApplicationZoneListRequest",
        self::GLEXPORTDATA => "AGLExportDataRequest",
        self::SERVICES => "AServicesRequest",
        self::SHIPPINGATTRIBUTES => "AShippingAttributesRequest",
        self::UPCLIST => "AUPCListRequest",
        self::MULTIIMAGE => 'AMultiImageRequest',
        self::ENTITYLIST => 'AEntityListRequest',
        self::PROMOENDED => 'APromoEndedRequest',
        self::GLSUMMARYDATA => 'AGLSummaryDataRequest',
        self::GLSINGLEINVOICE => 'AGLSingleInvoiceRequest',
        self::GLACCOUNTLIST => 'AGLAccountListRequest',
//        self::SLIDE => "ASlideRequest",
//        self::STORE => "AStoreRequest",
//        self::CONFIG => "AConfigRequest",
    );

    /**
     * Receives an intCode that is associated with the value of the request Action
     * @param $intCode
     * @return string
     */
    public static function ToString($intCode){
        switch($intCode) {
            case self::DATE : return "DateRequest";
            case self::CATEGORY : return "ACategoryRequest";
            case self::PRODUCT : return "AProductRequest";
            case self::IMAGE : return "AImageRequest";
            case self::INVENTORY : return "AInventoryRequest";
            case self::ATTRIBUTES : return "AProductAttributesRequest";
            case self::PROMO : return "APromoRequest";
            case self::TAX : return "ATaxRequest";
            case self::ADDTRANSACTION : return "AAddTransactionRequest";
            case self::APPLICATIONZONE : return "AApplicationZoneRequest";
            case self::APPLICATIONZONELIST : return "AApplicationZoneListRequest";
            case self::GLEXPORTDATA : return "AGLExportDataRequest";
            case self::SERVICES : return "AServicesRequest";
            case self::SHIPPINGATTRIBUTES : return "AShippingAttributesRequest";
            case self::UPCLIST : return "AUPCListRequest";
            case self::MULTIIMAGE : return "AMultiImageRequest";
            case self::ENTITYLIST : return "AEntityListRequest";
            case self::PROMOENDED : return "APromoEndedRequest";
            case self::GLSUMMARYDATA : return "AGLSummaryDataRequest";
            case self::GLSINGLEINVOICE : return "AGLSingleInvoiceRequest";
            case self::GLACCOUNTLIST : return "AGLAccountListRequest";
//            case self::SLIDE : return "ASlideRequest";
//            case self::STORE : return "AStoreRequest";
//            case self::CONFIG : return "AConfigRequest";
        }
    }

}