<?php
/**
 * Created by PhpStorm.
 * User: info_000
 * Date: 2015-12-15
 * Time: 13:10
 */

class ApiCredentials{

    protected $apiKey = null;
    protected $apiSecretKey = null;

    /** @var array */
    protected  $params = array ('apiurl' => _API_URL_,
        'signatureversion' => 1,
        'signaturemethod' => 'HmacSHA256',
    );

    public function __construct($apiKey, $apiSecretKey, $params = null){

        $this->apiKey = $apiKey;
        $this->apiSecretKey = $apiSecretKey;

        if (!is_null($params)){
            $this->params = array_merge($this->params, $params);
        }
    }

    /**
     * @return array
     * @throws Exception
     */
    protected function addRequiredParams(){
        $parameters = array();

        $parameters['apikey'] = $this->apiKey;

        if(!isset($this->params['timestamp'])){
            $parameters['timestamp'] = $this->getFormattedTimestamp(new DateTime('now', new DateTimeZone('UTC')));
        }else{
            $parameters['timestamp'] = $this->params['timestamp'];
        }

        $parameters['signatureversion'] = $this->params['signatureversion'];
        $parameters['signaturemethod'] = $this->params['signaturemethod'];
        $parameters['signature'] = $this->signParameters($parameters,$this->apiSecretKey);

        return $parameters;
    }

    /**
     * @param array $parameters
     * @param $key
     * @return string
     * @throws Exception
     */
    protected function signParameters($parameters, $key) {
        $signatureVersion = $parameters['signatureversion'];
        $algorithm = "HmacSHA1";
        $stringToSign = null;
        if (1 == $signatureVersion) {
            $algorithm = $this->params['signaturemethod'];
            $parameters['signaturemethod'] = $algorithm;
            $stringToSign = $this->StringToSignV1($parameters);
        } else {
            throw new Exception("Invalid Signature Version specified");
        }
        return $this->sign($stringToSign, $key, $algorithm);
    }

    /**
     * @param array $parameters
     * @return string
     */
    protected function StringToSignV1($parameters) {
        $parsedUrl = parse_url($this->params['apiurl']);
        $data = 'POST';
        $data .= "&";
        $data .= $parsedUrl['host'];
        $data .= "&";

        $data .= $this->getParametersAsString($parameters);
        //$data = "bob";

        return $data;
    }

    /**
     * Convert paremeters to Url encoded query string
     */
    protected function getParametersAsString($parameters){
        $queryParameters = array();
        foreach ($parameters as $key => $value) {
            //$queryParameters[] = $key . '=' . $value;
            $queryParameters[] = $key . '=' . $this->urlencode($value);
        }
        return implode('&', $queryParameters);
    }

    /**
     * @param $value
     * @return mixed
     */
    protected function urlencode($value) {
        return str_replace('%7E', '~', rawurlencode($value));
    }

    /**
     * Computes RFC 2104-compliant HMAC signature
     */
    protected function sign($data, $key, $algorithm)
    {
        if ($algorithm === 'HmacSHA1') {
            $hash = 'sha1';
        } else if ($algorithm === 'HmacSHA256') {
            $hash = 'sha256';
        } else {
            throw new Exception ("Non-supported signing method specified");
        }
       // return hash_hmac($hash, $data, $key);
        return base64_encode(
            hash_hmac($hash, $data, $key, true)
        );
    }

    /**
     * Returns a ISO 8601 formatted string from a DateTime instance.
     */
    protected function getFormattedTimestamp($dateTime) {
        if (!is_object($dateTime)) {
            if (is_string($dateTime)) {
                $dateTime = new DateTime($dateTime);
            } else {
                throw new Exception("Invalid date value.");
            }
        } else {
            if (!($dateTime instanceof DateTime)) {
                throw new Exception("Invalid date value.");
            }
        }
        return $dateTime->format(DATE_ATOM);
    }


}