<?php
class Request
{
	protected $request;
	protected $response;
	protected $result;

	public function __construct()
	{
		$this->request = simplexml_load_string('<?xml version="1.0" encoding="UTF-8"?><request></request>');
		if ($this->request === false){
			throw new Exception("Request is invalid XML");
		}
	}

	/**
	 * Builds the XML Node for API credentials
	 * @param $e
	 * @param $arrSignature
	 */
	protected function BuildCredentials($xmlParent, $arrSignature){
		if(is_array($arrSignature)){
			$nCreds = "";
			if(count($arrSignature) > 0){
				$nCreds = $xmlParent->addChild("credentials");

				foreach($arrSignature as $key => $value){
					$credItem = $nCreds->addChild(strtolower($key), $value);
				}
			}

		}
	}

	protected function BuildFilters($e, $filters)
	{
		if (is_array($filters))
		{
			if (count($filters) > 0){
				$e->addChild('filters');
			}

			foreach ($filters as $k => $v)
			{
				$filter = $e->filters->addChild('filter');
				$filter->addChild('field', $k);

				$v = preg_replace("/[\'\"]/", "", $v);

				if ($k == "when" || $k == "whenmod" || $k == "whenonline") {
                        $filter->addChild('after', $v);
                } else if ($k == "productfilter" || $k == "upccode" || $k == "start" || $k == "end" || $k == "mode" || $k == "lastsync" || $k == "matrixmode" || $k == "number" || $k == "lang") {
                        $filter->addChild('param', $v);
                /*} else if ($k == "sku") {
                		$filter->addChild('id', $v);*/ 	    
                } else {
                        $filter->addChild('like', $v);
                }

			}
		}
	}
	
	protected function GetElementText($xml, $s)
	{
		$return = $xml->xpath($s."/text()");
		return (count($return) == 1 ? $return[0] : $return);
	}
	
	public function Execute()
	{
		$url = _API_URL_;
		$data = array('request' => $this->request->asXML());

		$options = array
		(
			'http' => array
			(
				'header'  => "Content-type: application/x-www-form-urlencoded\r\n",
				'method'  => 'POST',
				'content' => http_build_query($data),
			),
		);

		$context = stream_context_create($options);
		$this->result = file_get_contents($url, false, $context);
		$this->response = simplexml_load_string($this->result);
	}
	
	public function GetResponse()
	{
		// If no XML is received from the server than generate an error XML.
		if ($this->response === false)
		{
			$this->response = simplexml_load_string('<?xml version="1.0" encoding="UTF-8"?><response></response>');
			$this->response->addChild("error", "Response is invalid XML");
			if ($this->response === false) throw new Exception("Could not build response XML");
		}
		return $this->response->asXML();
	}
}
