<?php
class Console
{
	public static function isCLI()
	{
		return (php_sapi_name() === 'cli');
	}

	public static function log($s, $type = "LOG")
	{
		$t = new DateTime();
		echo $t->format("Y-m-d H:i:s")." - ".$type.": ".$s.(Console::isCLI() ? "\n" : '<br>');
	}
	public static function warning($s) { Console::log($s, $type = "WARNING"); }
	public static function error($s) { Console::log($s, $type = "ERROR"); }
	
	public static function debug($o)
	{
		if (!Console::isCLI()) echo '<pre>';
		Console::log("DEBUG START");
		print_r($o);
		Console::log("DEBUG END");
		if (!Console::isCLI()) echo '</pre>';
	}
}
