<?php
define("ROOT", dirname(__FILE__));

// API URL - Do not change unless specified by a se2 team member
define("BASEURL", "https://api1.se2.ca/v2devtester/");

// API endpoint - Do not change unless specified by a se2 team member
define('_API_URL_',BASEURL.'get.php');

// Local HOME PATH (this is your installation path - with trailing slash ex: /home/user/public_html/alice/)
define("BASEDIR", "/home/se2/web/restclient/");

//Enter your API Credentials here. The code will automatically add them to every request you make with the AliceRest Class.
define("_API_ACCESS_KEY_","");
define("_API_SECRET_KEY_","");

// General setup
// Your timezone
date_default_timezone_set("America/Montreal");

// General configuration - experimental
define("DEBUG", false);

/*** INCLUDES THE REST CLIENT LIBRARY - DO NOT MODIFY ***/

require_once(ROOT . "/functions.php");
require_once(ROOT."/debug/loger.php");
require_once(ROOT."/request/requestType.php");
require_once(ROOT."/lang/languageType.php");
require_once(ROOT."/client/apicredentials.php");
require_once(ROOT."/client/client.php");
require_once(ROOT."/request/daterequest.php");
require_once(ROOT."/request/acategoryrequest.php");
require_once(ROOT."/request/aproductrequest.php");
require_once(ROOT."/request/aimagerequest.php");
require_once(ROOT."/request/amultiimagerequest.php");
require_once(ROOT."/request/ainventoryrequest.php");
require_once(ROOT."/request/aproductattributesrequest.php");
require_once(ROOT."/request/asliderequest.php");
require_once(ROOT."/request/astorerequest.php");
require_once(ROOT."/request/aconfigrequest.php");
require_once(ROOT."/request/apromorequest.php");
require_once(ROOT."/request/ataxrequest.php");
require_once(ROOT."/request/atransactionaddrequest.php");
require_once(ROOT."/request/aapplicationzonerequest.php");
require_once(ROOT."/request/aapplicationzonelistrequest.php");
require_once(ROOT."/request/aglexportdatarequest.php");
require_once(ROOT."/request/aservicesrequest.php");
require_once(ROOT."/request/ashippingattributesrequest.php");
require_once(ROOT."/request/aupclistrequest.php");
require_once(ROOT."/request/aentitylistrequest.php");
require_once(ROOT."/debug/console.php");
