<?php
/***
 * WARNING DO NOT MODIFY THIS FILE.
 * YOU WILL LOSE YOUR MODIFICATIONS WHEN THE SDK IS UPDATED.
 */
// Include the config file to load the sdk
require_once('config.php');

/***
 * Class AliceRequest
 *
 * Main request class to the API.
 *
 * This will handle all the requests for you.
 * All you need to do is set the parameters with an array while creating an instance of the class
 *
 * DO NOT MODIFY
 */
final class AliceRequest{

    protected $objClient = null;

    // PROPERTIES
    protected $requestType;
    protected $params = null;

    /**
     * List of supported Alice language
     */
    const FRENCH = 0;
    const ENGLISH = 1;
    const SPANISH = 2;

    /**
     * Array for the Alice language
     * @var array
     */
    public static $LanguageArray = array(
        self::ENGLISH => "En",
        self::FRENCH => "Fr",
        self::SPANISH => "Es"
    );

    /**
     * Returns the full string of the lang
     * @param $intCode
     * @return string
     */
    public static function LanguageToString($intCode){
        switch($intCode){
            case self::ENGLISH : return "English";
            case self::FRENCH : return "French";
            case self::SPANISH : return "Spanish";
        }
    }

    // Methods
    /**
     * AliceRequest constructor.
     * @param $type
     * @param null $params
     */
    public function __construct($key, $key2, $type, $params = null)
    {
        if ($key == '') {
            $key = _API_ACCESS_KEY_;
        }
        if ($key2 == '') {
            $key2 = _API_SECRET_KEY_;
        }

        $this->objClient = new Client($key, $key2);

        if(is_int($type)){
            if(array_key_exists($type,requestType::$RequestArray)){
                $this->requestType = $type;
            }else{
                throw new Exception('Request type not valid');
            }
        }
        if(!is_null($params)){
            if(is_array($params) && count($params) > 0){
                $this->params = $params;
            }
        }
    }

    /**
     * @return mixed
     */
    public function doRequest(){
        if(array_key_exists($this->requestType,requestType::$RequestArray)){
            
            $className = requestType::ToString($this->requestType);
            if(is_null($this->params) || count($this->params) == 0 ){
//               // $this->params = array();
                $req = new $className($this->objClient->getPublicSignature());
            }else{
                $req = new $className($this->objClient->getPublicSignature(),$this->params);
            }

            return $req->GetResponse();
        }
    }
}