<!DOCTYPE html>
<html lang="en">
	<head>
		<meta charset="utf-8">
		<meta name="viewport" content="width=device-width, initial-scale=1.0">
		<link rel="stylesheet" href="bootstrap/css/bootstrap.min.css">
		<link rel="stylesheet" href="bootstrap/css/bootstrap-theme.min.css">
	</head>
	<body>
		<div class="container">
			<h1>Alice REST API tester</h1>
			<hr>
			<form role="form" method="post" action="dorequest.php" target="_blank">
				<div class="row">
					<div class="col-xs-6">
						<div class="form-group">
							<label for="inputType">Type of request</label>
							<select class="form-control" id="inputType" name="type">
								<option value="date">Date</option>
								<option value="acategory">Alice categories</option>
								<option value="aproduct">Alice products</option>
								<option value="aimage">Alice images</option>
								<option value="amultiimage">Alice Multi Image</option>
								<option value="ainventory">Alice inventory</option>
								<option value="aproductattributes">Alice product attributes</option>
								<option value="apromo">Alice promotions</option>
								<option value="atax">Alice Taxes</option>
								<option value="aapplicationzone">System Application Zone</option>
								<option value="aapplicationzonelist">Application Zone List</option>
								<option value="aglexportdatarequest">GLExportData</option>
                                <option value="aglsummarydatarequest">GLSummaryData</option>
                                <option value="aglsingleinvoicerequest">GLSingleInvoice</option>
                                <option value="aglaccountlistrequest">GLAccountList</option>
								<option value="aservices">Alice Services</option>
								<option value="ashippingattributes">Shipping Attributes</option>
								<option value="aupclist">UPC List</option>
								<option value="aentitylist">Entity List</option>
                                <option value="apromoended">Promo Ended</option>
<!--								<option value="aslide">Company slides</option>-->
<!--								<option value="astore">Stores list</option>-->
<!--								<option value="aconfig">Configuration</option>-->
							</select>
						</div>
					</div>
				</div>
                <div class="row">
                    <div class="col-xs-6">
                        <div class="form-group">
                            <label for="unit1">Access</label>
                            <input type="password" class="form-control" id="unit1" name="unit1">
                        </div>
                        <div class="form-group">
                            <label for="unit2">Secret</label>
                            <input type="password" class="form-control" id="unit2" name="unit2">
                        </div>
                    </div>
                </div>
				<div id="legend" class="row">
					<div class="col-sm-6">
						<div class="well">
							<p><b>Fields</b></p>
							<p>
								General: from, to<br>
								Inventory: group, system, when<br>
								Products: &lt;currency=cad,usd,usdz1,cop,egp&gt;, when, classid, sku, name, withinventory, withimage, &lt;productfilter: 1 - All, 2 - With Activity, 3 - With Activity Past Year, 4 - In Stock, 5 - In Stock - Online Only. 6 - In Stock - In Store Only&gt;<br>
								Categories: when, lang<br>
								Product Attributes: parentid, lang, toplevel(any value)<br>
<!--								Slides: lang<br>-->
								Images/MultiImage: sku, name<br>
								Date/Promo/Tax/Services/Application Zone: none<br>
								Online Order: See Documentation<br>
								GL Export/Summary: start and end dates (YYYY-MM-DD) -- Mode for Summary(opt)<br>
                                GL Single Invoice: invoice number
                                GL Account List: lang (opt), mode (opt 0 by number (Def), 1 = byname, 2 = bytypenumber, 3 = bytypename)
								Entity List: mode (0 = All, 1 = Contact, 2 = Company) lastsync (YYYY-MM-DD HH:MM:SS)<br>

							</p>
						</div>
					</div>
					<div class="col-sm-6">
						<div class="well">
							<div class="row"><div class="col-xs-4"><b>Pattern</b></div><div class="col-xs-8"><b>Matches</b></div></div>
							<div class="row"><div class="col-xs-4">_</div><div class="col-xs-8">Any character</div></div>
							<div class="row"><div class="col-xs-4">%</div><div class="col-xs-8">Any string</div></div>
							<br>
							<div class="row"><div class="col-xs-4"><b>Language</b></div><div class="col-xs-8"><b>Value</b></div></div>
							<div class="row"><div class="col-xs-4">French</div><div class="col-xs-4">0</div></div>
							<div class="row"><div class="col-xs-4">English</div><div class="col-xs-4">1</div></div>
							<div class="row"><div class="col-xs-4">Spanish</div><div class="col-xs-4">2</div></div>
							<br>
							<div class="row"><div class="col-xs-4"><b>Attributes</b></div><div class="col-xs-8"><b>Value</b></div></div>
							<div class="row"><div class="col-xs-4">Manual</div><div class="col-xs-4">0</div></div>
							<div class="row"><div class="col-xs-4">Single</div><div class="col-xs-4">1</div></div>
						</div>
					</div>
				</div>
				<div id="filters"></div>
				<div class="well well-sm text-right">
					<div class="btn-group">
						<a href="#" id="add-filter" class="btn btn-success btn-mini">Add a filter</a>
						<button type="submit" class="btn btn-default">Request</button>
					</div>
				</div>
			</form>
		</div>
		<script src="https://code.jquery.com/jquery.js"></script>
		<script src="bootstrap/js/bootstrap.min.js"></script>
		<script src="js/dorequest.js"></script>
	</body>
</html>
