<?php
ini_set("max_execution_time", 43200);
require_once("../sdk/alicerequest.php");

if(DEBUG == true){
	ini_set('display_errors', 1);
	ini_set('display_startup_errors', 1);
	error_reporting(E_ALL);
}else{
	header ("Content-Type:text/xml");
}

// Get the Request type from the sandbox interface
$type = post("type");
$unit1 = post("unit1");
$unit2 = post("unit2");

// get the
$fields = post("field");

if (!is_array($fields)) $fields = array();

$filters = post("filter");
if (!is_array($filters)) $filters = array();

$a = array();

$reqType = null;
switch ($type){
	case "date":
		$reqType = requestType::DATE;
		break;
	case "acategory":
		foreach ($fields as $k => $field){
			$a[$field] = $filters[$k];
		}
		$reqType = requestType::CATEGORY;
		break;
	case "aproduct":
		foreach ($fields as $k => $field){
			$a[$field] = $filters[$k];
		}
		$reqType = requestType::PRODUCT;
		break;
	case "aimage":
		foreach ($fields as $k => $field){
			$a[$field] = $filters[$k];
		}
		$reqType = requestType::IMAGE;
		break;
	case "amultiimage":
		foreach ($fields as $k => $field){
			$a[$field] = $filters[$k];
		}
		$reqType = requestType::MULTIIMAGE;
		break;
	case "ainventory":
		foreach ($fields as $k => $field){
			$a[$field] = $filters[$k];
		}
		$reqType = requestType::INVENTORY;
		break;
	case "aproductattributes":
		foreach ($fields as $k => $field){
			$a[$field] = $filters[$k];
		}
		$reqType = requestType::ATTRIBUTES;
		break;
	case "apromo":
		foreach ($fields as $k => $field){
			$a[$field] = $filters[$k];
		}
		$reqType = requestType::PROMO;
		break;
	case "atax":
		$reqType = requestType::TAX;
		break;
	case "aaddtransaction":
		foreach ($fields as $k => $field) {
			$a[$field] = $filters[$k];
		}
		$reqType = requestType::ADDTRANSACTION;
		break;
	case "aapplicationzone":
		$reqType = requestType::APPLICATIONZONE;
		break;
	case "aapplicationzonelist":
		$reqType = requestType::APPLICATIONZONELIST;
		break;
	case "aglexportdatarequest":
		foreach ($fields as $k => $field){
			$a[$field] = $filters[$k];
		}
		$reqType = requestType::GLEXPORTDATA;
		break;
    case "aglsummarydatarequest":
        foreach ($fields as $k => $field){
            $a[$field] = $filters[$k];
        }
        $reqType = requestType::GLSUMMARYDATA;
        break;
    case "aglsingleinvoicerequest":
        foreach ($fields as $k => $field){
            $a[$field] = $filters[$k];
        }
        $reqType = requestType::GLSINGLEINVOICE;
        break;
    case "aglaccountlistrequest":
        foreach ($fields as $k => $field){
            $a[$field] = $filters[$k];
        }
        $reqType = requestType::GLACCOUNTLIST;
        break;
	case "aservices":
		$reqType = requestType::SERVICES;
		break;
	case "ashippingattributes":
		$reqType = requestType::SHIPPINGATTRIBUTES;
		break;
	case "aupclist":
		$reqType = requestType::UPCLIST;
		break;
	case "aentitylist":
		foreach ($fields as $k => $field) {
			$a[$field] = $filters[$k];
		}
		$reqType = requestType::ENTITYLIST;
		break;
    case "apromoended":
        foreach ($fields as $k => $field) {
            $a[$field] = $filters[$k];
        }
        $reqType = requestType::PROMOENDED;
        break;
		
//	case "aslide":
//		foreach ($fields as $k => $field){
//			$a[$field] = $filters[$k];
//		}
//		$reqType = requestType::SLIDE;
//		break;
//	case "astore":
//		foreach ($fields as $k => $field){
//			$a[$field] = $filters[$k];
//		}
//		$reqType = requestType::STORE;
//		break;
//	case "aconfig":
//		foreach ($fields as $k => $field){
//			$a[$field] = $filters[$k];
//		}
//		$reqType = requestType::CONFIG;
//		break;
}

//if(count($a) > 0){
//	$objRequest = new AliceRequest($reqType, $a);
//}elseif(count($a) == 0){
//	$objRequest = new AliceRequest($reqType);
//}
//

//Date and promo request do not take parameters
$objRequest = null;
if(($reqType != requestType::DATE) || ($reqType != requestType::PROMO) || ($reqType != requestType::TAX) || ($reqType != requestType::APPLICATIONZONE) 
	|| ($reqType != requestType::APPLICATIONZONELIST) || ($reqType != requestType::SERVICES) || ($reqType != requestType::SHIPPINGATTRIBUTES) || ($reqType != requestType::UPCLIST)){
	$objRequest = new AliceRequest($unit1, $unit2, $reqType, $a);
}else{
	$objRequest = new AliceRequest($unit1, $unit2, $reqType);
}
echo $objRequest->doRequest();

